*****************************************************
*           REGRESSIONSANALYSE                      *
*              Josef Brüderl                        *
*              Oktober 2018                         *
*****************************************************

*****************************************************
*     Bsp. Armut in Deutschland 
*****************************************************

clear 
set more off
version 15

* Daten: ALLBUS 2002
cd   "C:\Users\bruederl\LRZ Sync+Share\Vorlesung Querschnittsdatenanalyse\Do Files\Allbus 2002\"    //Datenverzeichnis
use  Allbus02, clear


* monatliches Netto-HHeinkommen
generate   hheink = v441

* Bestimmung der Personenzahl im HH
tab v363                     			 //HHgröße
generate   hhvorst = 1       			 //jeder HH hat einen Haushaltsvorstand
replace    hhvorst = . if v363==.
generate   sonst   = 0       			 //Initialisierung "Zahl sonstiger Personen über 14"
generate   kind14  = 0       			 //Initialisierung "Zahl Kinder unter 15"
replace    kind14  = kind14+1 if v369<15   //Bestimmung der Zahl der Kinder unter 15
replace    kind14  = kind14+1 if v379<15
replace    kind14  = kind14+1 if v389<15
replace    kind14  = kind14+1 if v399<15
replace    kind14  = kind14+1 if v409<15
replace    kind14  = kind14+1 if v419<15
replace    kind14  = kind14+1 if v429<15
replace    kind14  = . if v363==.
replace    sonst   = v363 - kind14 - 1	//Bestimmung der sonstigen Personen als Residualgröße

* Kontrolle
tab1     hhvorst sonst kind14
generate hhgr = hhvorst+sonst+kind14
tab1     hhgr v363

* Berechnung des bedarfsgewichteten Pro-Kopf-Einkommens 
* (Äquivalenzeinkommen) nach der OECD-Skala. Die OECD-Gewichte sind
* Haushaltsvorstand:         1.0
* weitere Personen über 14:  0.7
* Kinder unter 15:           0.5 
generate   oecdeink = hheink / (1*hhvorst + 0.7*sonst + 0.5*kind14)
summ       oecdeink, detail

gen    oecdeink1 = oecdeink        //Ausreisser wird auf 6000 rekodiert
recode oecdeink1 6000/max=6000

* Gruppiertes Boxplot West/Ost 
graph box oecdeink1, over(v3) ylabel(0(1000)6000, angle(horizontal) grid) ytitle("Nettoäquivalenzeinkommen", size(large))


* Bestimmung der Armutsgrenzen (60% des Medians)
summ oecdeink if v3==1, detail     //West
generate   wmed  = 0.6*r(p50)      //nach summ wird der median (50% percentile) von STATA gespeichert
summ oecdeink if v3==2, detail     //Ost
generate   omed  = 0.6*r(p50)
tab1 wmed omed

* Bestimmung der Armutsquoten
generate AQwest = oecdeink  if v3==1            //West
replace  AQwest = 1         if AQwest<=wmed
replace  AQwest = 0         if AQwest>wmed & AQwest<.
tab  AQwest
generate AQost = oecdeink  if v3==2            //Ost
replace  AQost = 1         if AQost<=omed
replace  AQost = 0         if AQost>omed & AQost<.
tab  AQost


* Kdensity Plot der Verteilungen
kdensity oecdeink1 if v3==1, lcolor(blue) lwidth(medthick) ///
           xline(682) xlabel(0(1000)6000) title(Kerndichteschätzer West)   ///
		   xtitle("Nettoäquivalenzeinkommen", size(large)) ytitle("Dichte", size(large))  ///
		   ylabel(0(.0002).001, angle(horizontal) grid) note("") aspectratio(.75)

kdensity oecdeink1 if v3==2, lcolor(blue) lwidth(medthick) ///
           xline(575) xlabel(0(1000)6000) title(Kerndichteschätzer Ost)   ///
		   xtitle("Nettoäquivalenzeinkommen", size(large)) ytitle("Dichte", size(large))  ///
		   ylabel(0(.0002).001, angle(horizontal) grid) note("")  aspectratio(.75)


* Konfidenzintervalle
sort v3
ci oecdeink, by(v3)

* t-Test
ttest oecdeink, by(v3)
